input price = close;
input displace = 0;
input length = 20;
input Num_Dev_Dn = -2.0;
input Num_Dev_up = 2.0;

def sDev = stdev(data = price[-displace], length = length);

plot MidLine = Average(data = price[-displace], length = length);
plot LowerBand = MidLine + num_Dev_Dn * sDev;
plot UpperBand = MidLine + num_Dev_Up * sDev;

LowerBand.SetDefaultColor(GetColor(0));
LowerBand.setdefaultcolor(color.WHITE);
LowerBand.setlineweight(2);

MidLine.SetDefaultColor(GetColor(1));
MidLine.SetStyle(curve.SHORT_DASH);
MidLine.hide();

UpperBand.SetDefaultColor(GetColor(5));
UpperBand.SetDefaultColor(color.WHITE);
UpperBand.setlineweight(2);

AddCloud(UpperBand, LowerBand, color.LIGHT_GRAY);
