# Bollinger Percent B study, based on work of HGSI Investor Group leader Ian Woodward, and original coding by Bob Meagher

declare lower;
input price = close;
input displace = 0;

# BollingerBandwidth

input AverageType = {default SMA, EMA};
input length = 20;
input Num_Dev_Dn = -2.0;
input Num_Dev_Up = 2.0;
input BulgeLength = 150;
input SqueezeLength = 150;

# Calculate Bollinger Bands for Price
def upperBand;
def lowerBand;
def midLine;

upperBand = BollingerBandsEMA(price, displace, length, Num_Dev_Dn, Num_Dev_Up).UpperBand;
lowerBand = BollingerBandsEMA(price, displace, length, Num_Dev_Dn, Num_Dev_Up).LowerBand;
midLine = BollingerBandsEMA(price, displace, length, Num_Dev_Dn, Num_Dev_Up).MidLine;

# BollingerPercentB
def PercentB = ((price - lowerBand) / (upperBand - lowerBand)) * 100;

#NOTE - the PercentB plot is turned off by using "def", instead of "plot".  Instead a 2-period avg is used to smooth the plot line and avoids some extreme spikes. Good enough for our purposes here
#PercentB.DefineColor("SlopePositive", Color.YELLOW);
#PercentB.DefineColor("SlopeNegative", Color.DARK_ORANGE);
#PercentB.AssignValueColor(if PercentB - ((PercentB[1] + PercentB[2]) / 2) > 0.0 then PercentB.Color("SlopePositive") else PercentB.Color("SlopeNegative"));
#PercentB.SetLineWeight(1);
#PercentB.SetPaintingStrategy(PaintingStrategy.LINE_VS_POINTS);
#PercentB.hide();

def PercentBprevious = PercentB[1] ;
def PercentB_Change = ((PercentB) - (PercentBprevious));

# Calculate Bollinger Bands for Percent B
plot UB_PctB = BollingerBandsEMA(PercentB, displace, 20, Num_Dev_Dn, Num_Dev_Up).UpperBand;
UB_PctB.setdefaultcolor(color.white);
#UB_PctB.Hide();

plot LB_PctB = BollingerBandsEMA(PercentB, displace, 20, Num_Dev_Dn, Num_Dev_Up).LowerBand;
LB_PctB.setdefaultcolor(color.white);
#LB_PctB.Hide();

plot Mid_PctB = BollingerBandsEMA(PercentB, displace, 20, Num_Dev_Dn, Num_Dev_Up).MidLine;
Mid_PctB.setdefaultcolor(color.white);
Mid_PctB.setlineweight(1);
#Mid_PctB.Hide();

# Calculate Bandwidth
def Bandwidth = ((upperBand - lowerBand) / midLine) * 100;
def Bulge = Highest(Bandwidth, BulgeLength);
def SqueezeBB = Lowest(Bandwidth, SqueezeLength);

# WOODY SECTION
plot Woody = (PercentB * Bandwidth) / 100;
Woody.SetLineWeight(2);
Woody.SetDefaultColor(Color.DARK_ORANGE);
Woody.Hide();

#Percent B Moving Averages
input displacePctB = 0;

plot PB_2 = Average(data = PercentB[-displace], length = 2);
plot PB_55 = WMA(data = PercentB[-displace], length = 55);
plot PB_89 = WMA(data = PercentB[-displace], length = 89);
plot PB_144 = WMA(data = PercentB[-displace], length = 144);
plot PB_233 = WMA(data = PercentB[-displace], length = 233);

PB_2.DefineColor("SlopePositive", Color.YELLOW);
PB_2.DefineColor("SlopeNegative", Color.DARK_ORANGE);
PB_2.AssignValueColor(if PB_2 - (PB_2[1] + PB_2[2] + PB_2[3]) / 3 > 0.0 then PB_2.Color("SlopePositive") else PB_2.Color("SlopeNegative"));
PB_2.SetLineWeight(1);
PB_2.setpaintingstrategy(PaintingStrategy.LINE_VS_POINTS);

PB_55.DefineColor("SlopePositive", Color.CYAN);
PB_55.DefineColor("SlopeNegative", Color.CYAN);
PB_55.AssignValueColor(if PB_55 - PB_55[1] > 0.0 then PB_55.Color("SlopePositive") else PB_55.Color("SlopeNegative"));
PB_55.SetLineWeight(2);

PB_89.DefineColor("SlopePositive", Color.MAGENTA);
PB_89.DefineColor("SlopeNegative", Color.MAGENTA);
PB_89.AssignValueColor(if PB_89 - PB_89[1] > 0.0 then PB_89.Color("SlopePositive") else PB_89.Color("SlopeNegative"));
PB_89.SetLineWeight(2);

PB_144.DefineColor("SlopePositive", Color.DARK_ORANGE);
PB_144.DefineColor("SlopeNegative", Color.DARK_ORANGE);
PB_144.AssignValueColor(if PB_144 - PB_144[1] > 0.0 then PB_144.Color("SlopePositive") else PB_144.Color("SlopeNegative"));
PB_144.SetLineWeight(2);

PB_233.DefineColor("SlopePositive", Color.RED);
PB_233.DefineColor("SlopeNegative", Color.RED);
PB_233.AssignValueColor(if PB_233 - PB_233[1] > 0.0 then PB_233.Color("SlopePositive") else PB_233.Color("SlopeNegative"));
PB_233.SetLineWeight(3);

# LINES

#Zero line

plot ZeroLine = 0.00;
ZeroLine.SetDefaultColor(COLOR.WHITE);
zEROlINE.SETLINEWEIGHT(1);
#ZeroLine.SetStyle(curve.SHORT_DASH);
#ZeroLine.hide();

plot L_100 = 100;
L_100.setdefaultcolor(color.RED);
L_100.setlineweight(1);


#EXTREME PCT B

plot FIB61B = (Highest(PercentB, 250) * .61);
FIB61B.SetDefaultColor(Color.GREEN);
FIB61B.SetLineWeight(2);
FIB61B.SetStyle(curve.SHORT_DASH);

plot FIB38B = (Highest(PercentB, 250) * .38);
FIB38B.SetDefaultColor(Color.MAGENTA);
FIB38B.SetLineWeight(2);
FIB38B.SetStyle(curve.SHORT_DASH);

#ADD CLOUD - provides a cloud for the Bollinger Band to make it easier to see against BLUE background

AddCloud(UB_PctB, Lb_PctB, Color.LIGHT_GRAY);
