#MOVING AVERAGES which are based on the ones used by Steve Bigalow


input price = close;

input displace = 0;
input FAST = 5;

plot EMA_FAST;
plot EMA8;
plot SMA20;
plot EMA34;
plot SMA50;
plot SMA200;

EMA_FAST = ExpAverage(price[-displace], FAST);
EMA_FAST.SetDefaultColor(color.YELLOW);
EMA_FAST.hide();

EMA8 = ExpAverage(price[-displace], 8);
EMA8.DefineColor("SlopePositive", Color.DARK_ORANGE);
EMA8.DefineColor("SlopeNegative", Color.RED);
EMA8.AssignValueColor(if EMA8 - (EMA8[1] + EMA8[2] + EMA8[3]) / 3 > 0.0 then EMA8.Color("SlopePositive") else EMA8.Color("SlopeNegative"));
EMA8.setpaintingstrategy(PaintingStrategy.LINE_VS_POINTS);
EMA8.setlineweight(1);

SMA20 = Average(price[-displace], 20);
SMA20.SetDefaultColor(color.CYAN);
SMA20.setlineweight(2);

AddCloud(EMA8,SMA20,color.green,color.red);

EMA34 = ExpAverage(price[-displace], 34);
EMA34.setdefaultcolor(color.MAGENTA);
EMA34.setlineweight(2);
EMA34.hide();

SMA50 = Average(price[-displace], 50);
SMA50.SetDefaultColor(color.YELLOW);
SMA50.setlineweight(3);

SMA200 = Average(price[-displace], 200);
SMA200.setdefaultcolor(color.RED);
SMA200.setlineweight(3);
