#
# Bongo_YesNo_RSI_Elder_Bob
#

declare lower;


input length = 9;
input displace = 0;

input length5 = 5;
input length8 = 8;
input length14 = 14;
input length19 = 19;

input over_Bought = 70;
input over_Sold = 30;
input price = close;


def sma = Average(data = price[-displace], length = length);

def NetChgAvg5 = WildersAverage(price - price[1], length5);
def NetChgAvg8 = WildersAverage(price - price[1], length8);
def NetChgAvg14 = WildersAverage(price - price[1], length14);
def NetChgAvg19 = WildersAverage(price - price[1], length19);

def TotChgAvg5 = WildersAverage(AbsValue(price - price[1]), length5);
def TotChgAvg8 = WildersAverage(AbsValue(price - price[1]), length8);
def TotChgAvg14 = WildersAverage(AbsValue(price - price[1]), length14);
def TotChgAvg19 = WildersAverage(AbsValue(price - price[1]), length19);

def ChgRatio5 = if TotChgAvg5 != 0 then NetChgAvg5 / TotChgAvg5 else 0;
def ChgRatio8 = if TotChgAvg8 != 0 then NetChgAvg8 / TotChgAvg8 else 0;
def ChgRatio14 = if TotChgAvg14 != 0 then NetChgAvg14 / TotChgAvg14 else 0;
def ChgRatio19 = if TotChgAvg19 != 0 then NetChgAvg19 / TotChgAvg19 else 0;


plot RSI5 = 50 * (ChgRatio5 + 1);
plot RSI8 = 50 * (ChgRatio8 + 1);
plot RSI14 = 50 * (ChgRatio14 + 1);
plot RSI19 = 50 * (ChgRatio19 + 1);

plot Bongo_Yes = IF (RSI8 > RSI14 and RSI14 > RSI19 and close > sma) then (RSI8 > RSI14 and RSI14 > RSI19 and close > sma)*5 else double.nan ;

plot OverSold = over_Sold;
plot OverBought = over_Bought;

RSI5.AssignValueColor(if RSI5 > over_Bought then GetColor(5) else if RSI5 < over_Sold then GetColor(7) else GetColor(0));

RSI8.AssignValueColor(if RSI8 > over_Bought then GetColor(5) else if RSI8 < over_Sold then GetColor(7) else GetColor(1));

RSI14.AssignValueColor(if RSI14 > over_Bought then GetColor(5) else if RSI14 < over_Sold then GetColor(7) else GetColor(2));

RSI19.AssignValueColor(if RSI19 > over_Bought then GetColor(5) else if RSI19 < over_Sold then GetColor(7) else GetColor(3));

RSI5.hide();
RSI8.hide();
RSI14.hide();
RSI19.hide();

OverSold.SetDefaultColor(GetColor(8));
OverBought.SetDefaultColor(GetColor(8));

OverSold.hide();
OverBought.hide();

Bongo_Yes.SetLineWeight(5);
Bongo_Yes.SetDefaultColor(Color.Green);
Bongo_Yes.SetPaintingStrategy(paintingstrategy.DASHES);

plot Bongo_No = IF (RSI8 < RSI14 and RSI14 < RSI19 and close < sma) then (RSI8 < RSI14 and RSI14 < RSI19 and close < sma) *5 else double.nan ;
Bongo_No.SetLineWeight(5);
#Bongo_No.SetPaintingStrategy(paintingstrategy.histogram);
Bongo_No.SetPaintingStrategy(paintingstrategy.DASHES);
Bongo_No.SetDefaultColor(Color.Red);




# Elder Impulse System Study - Bob


input Elength = 13;

def EMA = MovAvgExponential(length = Elength)."AvgExp";
def MACDHist = MACDHistogram()."Diff";

def impulseSignal = if (EMA < EMA[1] and MACDHist < MACDHist[1]) 
then 0
 else if (EMA > EMA[1] and MACDHist > MACDHist[1])
 then 1
 else -1;

plot signal = -5;

signal.AssignValueColor(if impulseSignal == 1 then Color.Green else if impulseSignal == 0 then Color.Red else Color.YELLOW);

signal.SetPaintingStrategy(paintingstrategy.DASHES);
signal.SetLineWeight(5);
signal.HideBubble();
